package gov.va.genisis2Test.abstractClass;

import static org.springframework.test.web.servlet.setup.MockMvcBuilders.standaloneSetup;

import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.validation.BindingResult;

import gov.va.genisis2.bo.ActivitiService;
import gov.va.genisis2.bo.BusinessService;
import gov.va.genisis2.controller.Genisis2Controller;
import gov.va.genisis2.dao.impl.CommentHistoryDao;
import gov.va.genisis2.dao.impl.LookUpDao;
import gov.va.genisis2.dao.impl.RequestDao;
import gov.va.genisis2.dao.impl.StudyApprovalDao;
import gov.va.genisis2.dao.impl.UserManagementDAO;
import gov.va.genisis2.service.impl.CommentHistoryService;
import gov.va.genisis2.service.impl.LookUpService;
import gov.va.genisis2.service.impl.RequestService;
import gov.va.genisis2.service.impl.StudyApprovalService;
import gov.va.genisis2.service.impl.UserManagementService;

/**
 * The Class AbstractMockMvcTests.
 *
 * @author1 Janet Lopez
 * @author2 Getaneh Kassahun
 * 
 *          The Class AbstractMockMvcTests.
 * 
 *          Description: In this Abstract Class, data and methods are defined to
 *          create an instance of Genisis2Controller and pass in an instance of
 *          the mocked interface by using the Object property to basically
 *          injecting the dependency by hand.
 */

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration("file:src/test/resources/applicationContext.xml")
public class AbstractMockMvcTests {

	/** The newline. */
	protected static String newline = "<br />";

	/** The mock mvc. */
	protected MockMvc mockMvc;

	/** The genisis 2 controller. */
	@InjectMocks
	protected Genisis2Controller genisis2Controller;

	/** The mock comment history dao. */
	@Mock
	protected CommentHistoryDao mockCommentHistoryDao;

	/** The mock look up dao. */
	@Mock
	protected LookUpDao mockLookUpDao;

	/** The mock request dao. */
	@Mock
	protected RequestDao mockRequestDao;

	/** The mock study approval dao. */
	@Mock
	protected StudyApprovalDao mockStudyApprovalDao;

	/** The mock user management dao. */
	@Mock
	protected UserManagementDAO mockUserManagementDao;

	/** The mock hibernate template. */
	@Mock
	protected HibernateTemplate mockHibernateTemplate;

	/** The result. */
	@Mock
	protected BindingResult result;

	/** The mock activiti service. */
	@Mock
	protected ActivitiService mockActivitiService;

	/** The mock business service. */
	@Mock
	BusinessService mockBusinessService;

	/** The mock comment history service. */
	@Mock
	protected CommentHistoryService mockCommentHistoryService;

	/** The mock look up service. */
	@Mock
	protected LookUpService mockLookUpService;

	/** The mock request service. */
	@Mock
	protected RequestService mockRequestService;

	/** The mock study approval service. */
	@Mock
	protected StudyApprovalService mockStudyApprovalService;

	/** The mock user management service. */
	@Mock
	protected UserManagementService mockUserManagementService;

	/**
	 * Gets the mock mvc.
	 *
	 * @return the mock mvc
	 */
	public MockMvc getMockMvc() {
		return this.mockMvc;
	}

	/**
	 * Gets the mock comment history dao.
	 *
	 * @return the mock comment history dao
	 */
	public CommentHistoryDao getMockCommentHistoryDao() {
		return mockCommentHistoryDao;
	}

	/**
	 * Gets the mock look up dao.
	 *
	 * @return the mock look up dao
	 */
	public LookUpDao getMockLookUpDao() {
		return mockLookUpDao;

	}

	/**
	 * Gets the mock request dao.
	 *
	 * @return the mock request dao
	 */
	public RequestDao getMockRequestDao() {
		return mockRequestDao;
	}

	/**
	 * Gets the mock study approval dao.
	 *
	 * @return the mock study approval dao
	 */
	public StudyApprovalDao getMockStudyApprovalDao() {
		return mockStudyApprovalDao;
	}

	/**
	 * Gets the mock user management dao.
	 *
	 * @return the mock user management dao
	 */
	public UserManagementDAO getMockUserManagementDao() {
		return mockUserManagementDao;
	}

	/**
	 * Gets the genisis 2 controller.
	 *
	 * @return the genisis 2 controller
	 */
	public Genisis2Controller getGenisis2Controller() {
		return genisis2Controller;
	}

	/**
	 * Gets the activiti service.
	 *
	 * @return the activiti service
	 */
	public ActivitiService getMockActivitiService() {
		return this.mockActivitiService;
	}

	/**
	 * Gets the business service.
	 *
	 * @return the business service
	 */
	public BusinessService getMockBusinessService() {
		return this.mockBusinessService;
	}

	/**
	 * Gets the comment history service.
	 *
	 * @return the study approval service
	 */
	public CommentHistoryService getMockCommentHistoryService() {
		return this.mockCommentHistoryService;
	}

	/**
	 * Gets the mock look up service.
	 *
	 * @return the mock look up service
	 */
	public LookUpService getMockLookUpService() {
		return this.mockLookUpService;
	}

	/**
	 * Gets the request service.
	 *
	 * @return the request service
	 */
	public RequestService getMockRequestService() {
		return this.mockRequestService;
	}

	/**
	 * Gets the study approval service.
	 *
	 * @return the study approval service
	 */
	public StudyApprovalService getMockStudyApprovalService() {
		return this.mockStudyApprovalService;
	}

	/**
	 * Gets the user management service.
	 *
	 * @return the user management service
	 */
	public UserManagementService getMockUserManagementService() {
		return this.mockUserManagementService;
	}

	/**
	 * Setup.
	 *
	 * @throws Exception
	 *             the exception
	 */
	@Before
	public void setup() throws Exception {
		MockitoAnnotations.initMocks(this);
		this.mockMvc = standaloneSetup(genisis2Controller)
				.setMessageConverters(new MappingJackson2HttpMessageConverter()).build();
	}

	/**
	 * Teardown.
	 *
	 * @throws Exception
	 *             the exception
	 */

	@After
	public void teardown() throws Exception {
	}

	/**
	 * Gets the mock hibernate template.
	 *
	 * @return the mock hibernate template
	 */
	public HibernateTemplate getMockHibernateTemplate() {
		return mockHibernateTemplate;
	}

	/**
	 * Sets the mock hibernate template.
	 *
	 * @param mockHibernateTemplate
	 *            the new mock hibernate template
	 */
	public void setMockHibernateTemplate(HibernateTemplate mockHibernateTemplate) {
		this.mockHibernateTemplate = mockHibernateTemplate;
	}
}